#############################################################################
#############################################################################
#
# latexKeys.tcl (called from latex.tcl)
#
# Special LaTeX key bindings (see latexMenu.tcl for additional bindings)
#
# abbreviations:  <o> = option, <z> = control, <s> = shift, <c> = command
#
#############################################################################
#
# Author:  Tom Scavo <trscavo@syr.edu>
#
#############################################################################
proc latexKeys.tcl {} {}

##############################################################################

# Initial binding of LaTeX command keys.
proc bindLaTeXKeys {} {
	
    proc bindKeypadKeys {} {
	global TeXmodeVars
	# Completely take over the keypad:
	set mods {<> <c> <o> <z> <s> <co> <cz> <cs> <oz> <os> <zs> \
	  <coz> <cos> <ozs> <cozs>}
	if {$TeXmodeVars(takeOverNumericKeypad)} {
	    foreach mod $mods {
		Bind Kpad0 $mod dummyTeX "TeX"
		Bind Kpad1 $mod dummyTeX "TeX"
		Bind Kpad2 $mod dummyTeX "TeX"
		Bind Kpad3 $mod dummyTeX "TeX"
		Bind Kpad4 $mod dummyTeX "TeX"
		Bind Kpad5 $mod dummyTeX "TeX"
		Bind Kpad6 $mod dummyTeX "TeX"
		Bind Kpad7 $mod dummyTeX "TeX"
		Bind Kpad8 $mod dummyTeX "TeX"
		Bind Kpad9 $mod dummyTeX "TeX"
		Bind Kpad= $mod dummyTeX "TeX"
		Bind Kpad/ $mod dummyTeX "TeX"
		Bind Kpad* $mod dummyTeX "TeX"
		Bind Kpad- $mod dummyTeX "TeX"
		Bind Kpad+ $mod dummyTeX "TeX"
		Bind Enter $mod dummyTeX "TeX"
		Bind Kpad. $mod dummyTeX "TeX"
	    }
	}
	
	Bind Kpad8 prevSubsection "TeX"
	Bind Kpad2 nextSubsection "TeX"
	Bind Kpad8 <s> prevSubsectionSelect "TeX"
	Bind Kpad2 <s> nextSubsectionSelect "TeX"
	Bind Kpad8 <c> prevSection "TeX"
	Bind Kpad2 <c> nextSection "TeX"
	Bind Kpad8 <sc> prevSectionSelect "TeX"
	Bind Kpad2 <sc> nextSectionSelect "TeX"
	Bind Kpad4 prevCommand "TeX"
	Bind Kpad6 nextCommand "TeX"
	Bind Kpad4 <s> prevCommandSelect "TeX"
	Bind Kpad6 <s> nextCommandSelect "TeX"
	Bind Kpad4 <so> prevCommandSelectWithArgs "TeX"
	Bind Kpad6 <so> nextCommandSelectWithArgs "TeX"
	Bind Kpad4 <c> prevEnvironment "TeX"
	Bind Kpad6 <c> nextEnvironment "TeX"
	Bind Kpad4 <sc> prevEnvironmentSelect "TeX"
	Bind Kpad6 <sc> nextEnvironmentSelect "TeX"
    }
	
    proc bindGreekKeys {func} {
	$func	'm'	<z>	prefixChar "TeX"
	$func	'a'	<M>	[list TeX::mp::greek "" alpha] "TeX"
	$func	'b'	<M>	[list TeX::mp::greek "" beta]	"TeX"
	$func	'c'	<M>	[list TeX::mp::greek "" chi]	"TeX"
	$func	'd'	<M>	[list TeX::mp::greek "" delta]	"TeX"
	$func	'd'	<sM>	[list TeX::mp::greek "" Delta]	"TeX"
	$func	'e'	<M>	[list TeX::mp::greek "" epsilon]	"TeX"
	$func	'e'	<zM>	[list TeX::mp::greek "" varepsilon]	"TeX"
	$func	'f'	<M>	[list TeX::mp::greek "" phi]	"TeX"
	$func	'f'	<sM>	[list TeX::mp::greek "" Phi]	"TeX"
	$func	'f'	<zM>	[list TeX::mp::greek "" varphi]	"TeX"
	$func	'g'	<M>	[list TeX::mp::greek "" gamma]	"TeX"
	$func	'g'	<sM>	[list TeX::mp::greek "" Gamma]	"TeX"
	$func	'h'	<M>	[list TeX::mp::greek "" eta]	"TeX"
	$func	'i'	<M>	[list TeX::mp::greek "" iota]	"TeX"
	$func	'k'	<M>	[list TeX::mp::greek "" kappa]	"TeX"
	$func	'l'	<M>	[list TeX::mp::greek "" lambda]	"TeX"
	$func	'l'	<sM>	[list TeX::mp::greek "" Lambda]	"TeX"
	$func	'm'	<M>	[list TeX::mp::greek "" mu]	"TeX"
	$func	'n'	<M>	[list TeX::mp::greek "" nu]	"TeX"
	$func	'o'	<M>	[list TeX::mp::greek "" omicron]	"TeX"
	$func	'p'	<M>	[list TeX::mp::greek "" pi]	"TeX"
	$func	'p'	<sM>	[list TeX::mp::greek "" Pi]	"TeX"
	$func	'p'	<zM>	[list TeX::mp::greek "" varpi]	"TeX"
	$func	'q'	<M>	[list TeX::mp::greek "" theta]	"TeX"
	$func	'q'	<sM>	[list TeX::mp::greek "" Theta]	"TeX"
	$func	'q'	<zM>	[list TeX::mp::greek "" vartheta]	"TeX"
	$func	'r'	<M>	[list TeX::mp::greek "" rho]	"TeX"
	$func	'r'	<zM>	[list TeX::mp::greek "" varrho]	"TeX"
	$func	's'	<M>	[list TeX::mp::greek "" sigma]	"TeX"
	$func	's'	<sM>	[list TeX::mp::greek "" Sigma]	"TeX"
	$func	's'	<zM>	[list TeX::mp::greek "" varsigma]	"TeX"
	$func	't'	<M>	[list TeX::mp::greek "" tau]	"TeX"
	$func	'u'	<M>	[list TeX::mp::greek "" upsilon]	"TeX"
	$func	'u'	<sM>	[list TeX::mp::greek "" Upsilon]	"TeX"
	$func	'v'	<M>	[list TeX::mp::greek "" nabla]	"TeX"
	$func	'w'	<M>	[list TeX::mp::greek "" omega]	"TeX"
	$func	'w'	<sM>	[list TeX::mp::greek "" Omega]	"TeX"
	$func	'x'	<M>	[list TeX::mp::greek "" xi]	"TeX"
	$func	'x'	<sM>	[list TeX::mp::greek "" Xi]	"TeX"
	$func	'y'	<M>	[list TeX::mp::greek "" psi]	"TeX"
	$func	'y'	<sM>	[list TeX::mp::greek "" Psi]	"TeX"
	$func	'z'	<M>	[list TeX::mp::greek "" zeta]	"TeX"
    }

    bindKeypadKeys
    bindGreekKeys "Bind"
	
    # Bind double quote:
    ascii 0x22 <s> smartDQuote TeX
    # Bind single quote:
    ascii 0x27 smartQuote TeX
    # Bind period:
    ascii 0x2e smartDots "TeX"
    # Bind delete key: (use ascii to avoid dead-key problem)
    #Bind 0x33 escapeSmartStuff "TeX"
    ascii 0x08 escapeSmartStuff "TeX"

}
